{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 01.09.98 - 17:09:19 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMSystem, MMHook, MMDesign, MMConect, MMObj, MMDSPObj, MMWavIn,
  MMMeter, MMUtils, ExtCtrls, MMPCMSup;

type
  TForm1 = class(TForm)
    Meter1: TMMMeter;
    Meter2: TMMMeter;
    WaveIn: TMMWaveIn;
    MMConnector1: TMMConnector;
    MMDesigner1: TMMDesigner;
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    DCLeft: TLabel;
    DCRight: TLabel;
    DBLeft: TLabel;
    DBRight: TLabel;
    Timer1: TTimer;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure Timer1Timer(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    Calibrate: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
   Calibrate := False;
   WaveIn.Start;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveIn.Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   Calibrate := True;
end;

procedure TForm1.WaveInBufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
var
   AvgL, AvgR, RmsL, RmsR: SmallInt;

begin
   if Calibrate then
   begin
      pcmCalcStatistics(WaveIn.PWaveFormat,
                        lpWaveHdr.lpData,
                        lpWaveHdr.dwBytesRecorded,
                        AvgL, AvgR, RmsL, RmsR);

      DCLeft.Caption := IntToStr(AvgL);
      DCRight.Caption := IntToStr(AvgR);

      Meter1.DCOffsetL := AvgL;
      Meter1.DCOffsetR := AvgR;

      Meter2.DCOffsetL := AvgL;
      Meter2.DCOffsetR := AvgR;

      Calibrate := False;
   end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   DCLeft.Caption := '0';
   DCRight.Caption := '0';

   Meter1.DCOffsetL := 0;
   Meter1.DCOffsetR := 0;

   Meter2.DCOffsetL := 0;
   Meter2.DCOffsetR := 0;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
   DBLeft.Caption := VolumeToString(Meter1.Peak,32767,2);
   DBRight.Caption := VolumeToString(Meter2.Peak,32767,2);
end;

end.
